/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.itemstages;

import java.util.ArrayList;
import net.darkhax.bookshelf.util.TextUtils;
import net.darkhax.gamestages.GameStageHelper;
import net.darkhax.gamestages.data.GameStageSaveHandler;
import net.darkhax.gamestages.data.IStageData;
import net.darkhax.itemstages.Restriction;
import net.darkhax.itemstages.RestrictionManager;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Util;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="itemstages")
public class ItemStages {
    public static final Logger LOGGER = LogManager.getLogger((String)"Item Stages");

    public ItemStages() {
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerTick);
        MinecraftForge.EVENT_BUS.addListener(this::onItemPickup);
        MinecraftForge.EVENT_BUS.addListener(this::onItemUsed);
        MinecraftForge.EVENT_BUS.addListener(this::onEntityHurt);
        MinecraftForge.EVENT_BUS.addListener(this::addReloadListeners);
        if (FMLEnvironment.dist.isClient()) {
            MinecraftForge.EVENT_BUS.addListener(this::onItemTooltip);
        }
    }

    private void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)RestrictionManager.INSTANCE);
    }

    private void onEntityHurt(LivingAttackEvent event) {
        ItemStack stack;
        PlayerEntity player;
        Restriction restriction;
        if (this.canAffectPlayer(event.getSource()) && (restriction = RestrictionManager.INSTANCE.getRestriction(player = (PlayerEntity)event.getSource().func_76346_g(), stack = player.func_184614_ca())) != null && restriction.shouldPreventAttacking()) {
            event.setCanceled(true);
            ITextComponent message = restriction.getAttackMessage(stack);
            player.func_145747_a(message, Util.field_240973_b_);
        }
    }

    private void onItemUsed(PlayerInteractEvent event) {
        if (event.isCancelable() && this.canAffectPlayer(event.getPlayer())) {
            ItemStack stack = event.getItemStack();
            Restriction restriction = RestrictionManager.INSTANCE.getRestriction(event.getPlayer(), stack);
            if (restriction != null && restriction.shouldPreventUsing()) {
                event.setCanceled(true);
                ITextComponent message = restriction.getUsageMessage(stack);
                event.getPlayer().func_145747_a(message, Util.field_240973_b_);
            }
        }
    }

    private void onItemPickup(EntityItemPickupEvent event) {
        if (this.canAffectPlayer(event.getPlayer())) {
            ItemStack stack = event.getItem().func_92059_d();
            Restriction restriction = RestrictionManager.INSTANCE.getRestriction(event.getPlayer(), stack);
            if (restriction != null && restriction.shouldPreventPickup()) {
                event.setCanceled(true);
                event.getItem().func_174867_a(restriction.getPickupDelay());
                ITextComponent message = restriction.getPickupMessage(stack);
                event.getPlayer().func_145747_a(message, Util.field_240973_b_);
            }
        }
    }

    private void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.player != null && !event.player.field_70170_p.field_72995_K && !(event.player instanceof FakePlayer)) {
            PlayerEntity player = event.player;
            IStageData stageData = GameStageHelper.getPlayerData((PlayerEntity)player);
            PlayerInventory inv = player.field_71071_by;
            int armorStart = inv.field_70462_a.size();
            int armorEnd = armorStart + inv.field_70460_b.size();
            for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
                ITextComponent message;
                Restriction restriction;
                ItemStack slotContent = inv.func_70301_a(slot);
                if (slotContent.func_190926_b()) continue;
                if (slot >= armorStart && slot <= armorEnd) {
                    restriction = RestrictionManager.INSTANCE.getEquipmentRestriction(player, stageData, slotContent);
                    if (restriction == null || !restriction.shouldPreventEquipment()) continue;
                    inv.func_70299_a(slot, ItemStack.field_190927_a);
                    player.func_71019_a(slotContent, false);
                    message = restriction.getDropMessage(slotContent);
                    if (message == null) continue;
                    player.func_145747_a(message, Util.field_240973_b_);
                    continue;
                }
                restriction = RestrictionManager.INSTANCE.getInventoryRestriction(player, stageData, slotContent);
                if (restriction == null || !restriction.shouldPreventInventory()) continue;
                inv.func_70299_a(slot, ItemStack.field_190927_a);
                player.func_71019_a(slotContent, false);
                message = restriction.getDropMessage(slotContent);
                if (message == null) continue;
                player.func_145747_a(message, Util.field_240973_b_);
            }
        }
    }

    private void onItemTooltip(ItemTooltipEvent event) {
        ItemStack stack;
        IStageData data;
        PlayerEntity player;
        Restriction restriction;
        if (event.getPlayer() != null && (restriction = RestrictionManager.INSTANCE.getRestriction(player = event.getPlayer(), data = GameStageSaveHandler.getClientData(), stack = event.getItemStack())) != null) {
            event.getToolTip().clear();
            ITextComponent hiddenName = restriction.getHiddenName(stack);
            if (hiddenName != null) {
                event.getToolTip().add(hiddenName);
            }
            if (event.getFlags().func_194127_a()) {
                ArrayList<IFormattableTextComponent> stages = new ArrayList<IFormattableTextComponent>();
                IFormattableTextComponent sep = new StringTextComponent(", ").func_240699_a_(TextFormatting.GRAY);
                for (String stage : restriction.getStages()) {
                    stages.add(new StringTextComponent(stage).func_240699_a_(data.hasStage(stage) ? TextFormatting.GREEN : TextFormatting.RED));
                }
                IFormattableTextComponent desc = new TranslationTextComponent("tooltip.itemstages.item.description", new Object[]{TextUtils.join((ITextComponent)sep, stages)}).func_240699_a_(TextFormatting.GRAY);
                event.getToolTip().add(desc);
                if (restriction.shouldPreventInventory()) {
                    event.getToolTip().add(new TranslationTextComponent("tooltip.itemstages.debug.drop").func_240699_a_(TextFormatting.RED));
                }
                if (restriction.shouldPreventPickup()) {
                    event.getToolTip().add(new TranslationTextComponent("tooltip.itemstages.debug.pickup").func_240699_a_(TextFormatting.RED));
                }
                if (restriction.shouldPreventUsing()) {
                    event.getToolTip().add(new TranslationTextComponent("tooltip.itemstages.debug.use").func_240699_a_(TextFormatting.RED));
                }
                if (restriction.shouldPreventAttacking()) {
                    event.getToolTip().add(new TranslationTextComponent("tooltip.itemstages.debug.attack").func_240699_a_(TextFormatting.RED));
                }
                if (restriction.shouldHideInJEI()) {
                    event.getToolTip().add(new TranslationTextComponent("tooltip.itemstages.debug.jei").func_240699_a_(TextFormatting.RED));
                }
            }
        }
    }

    private final boolean canAffectPlayer(DamageSource source) {
        return source != null && source.func_76346_g() instanceof PlayerEntity && this.canAffectPlayer((PlayerEntity)source.func_76346_g());
    }

    private final boolean canAffectPlayer(PlayerEntity player) {
        return player != null && !player.field_70170_p.field_72995_K && !(player instanceof FakePlayer);
    }
}

